% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{recodeData}
\alias{recodeData}
\title{Returns a list of the design matrix \code{X} and updated \code{pars} and
\code{randPars} to include any dummy-coded categorical or interaction
variables.}
\usage{
recodeData(data, pars, randPars)
}
\arguments{
\item{data}{The data, formatted as a \code{data.frame} object.}

\item{pars}{The names of the parameters to be estimated in the model.
Must be the same as the column names in the \code{data} argument. For WTP space
models, do not include price in \code{pars} - it should instead be defined by
the \code{scalePar} argument.}

\item{randPars}{A named vector whose names are the random parameters and
values the distribution: \code{'n'} for normal or \code{'ln'} for log-normal.
Defaults to \code{NULL}.}
}
\value{
A list of the design matrix (\code{X}) and two vectors (\code{pars} and
\code{randPars}) with discrete (categorical) variables and interaction variables
added.
}
\description{
Recodes the data and returns a list of the encoded design matrix (\code{X}) as
well as two vectors (\code{pars} and \code{randPars}) with discrete (categorical)
variables and interaction variables added to \code{X}, \code{pars}, and
\code{randPars}.
}
\examples{
library(logitr)

data(yogurt)

# Recode the yogurt data
result <- recodeData(
    data = yogurt,
    pars = c("price", "feat", "brand", "price*brand"),
    randPars = c(feat = "n", brand = "n")
)

result$pars
result$randPars
head(result$X)
}
