% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{logisticPCA}
\alias{logisticPCA}
\title{Logistic Principal Component Analysis}
\usage{
logisticPCA(x, k = 2, M = 4, quiet = TRUE, use_irlba = FALSE,
  max_iters = 1000, conv_criteria = 1e-05, random_start = FALSE, start_U,
  start_mu, main_effects = TRUE, validation)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{k}{number of principal components to return}

\item{M}{value to approximate the saturated model. If \code{M = 0}, M is solved for}

\item{quiet}{logical; whether the calculation should give feedback}

\item{use_irlba}{logical; if \code{TRUE}, the function uses the irlba package
to more quickly calculate the eigen-decomposition}

\item{max_iters}{number of maximum iterations}

\item{conv_criteria}{convergence criteria. The difference between average deviance
in successive iterations}

\item{random_start}{logical; whether to randomly inititalize the parameters. If \code{FALSE},
function will use an eigen-decomposition as starting value}

\item{start_U}{starting value for the orthogonal matrix}

\item{start_mu}{starting value for mu. Only used if \code{main_effects = TRUE}}

\item{main_effects}{logical; whether to include main effects in the model}

\item{validation}{optional validation matrix. If supplied and \code{M = 0}, the
  validation data is used to solve for \code{M}}
}
\value{
An S3 object of class \code{lpca} which is a list with the
following components:
\item{mu}{the main effects}
\item{U}{a \code{k}-dimentional orthonormal matrix with the loadings}
\item{PCs}{the princial component scores}
\item{M}{the parameter inputed or solved for}
\item{iters}{number of iterations required for convergence}
\item{loss_trace}{the trace of the average negative log likelihood of the algorithm.
   Should be non-increasing}
\item{prop_deviance_expl}{the proportion of deviance explained by this model.
   If \code{main_effects = TRUE}, the null model is just the main effects, otherwise
   the null model estimates 0 for all natural parameters.}
}
\description{
Dimensionality reduction for binary data by extending Pearson's
PCA formulation to minimize Binomial deviance
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic PCA on it
lpca = logisticPCA(mat, k = 1, M = 4, main_effects = FALSE)

# Logistic PCA likely does a better job finding latent features
# than standard PCA
plot(svd(mat_logit)$u[, 1], lpca$PCs[, 1])
plot(svd(mat_logit)$u[, 1], svd(mat)$u[, 1])
}

