% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticSVD.R
\name{fitted.lsvd}
\alias{fitted.lsvd}
\title{Fitted values using logistic SVD}
\usage{
\method{fitted}{lsvd}(object, type = c("link", "response"), ...)
}
\arguments{
\item{object}{logistic SVD object}

\item{type}{the type of fitting required. \code{type = "link"} gives output on the logit scale and
\code{type = "response"} gives output on the probability scale}

\item{...}{Additional arguments}
}
\description{
Fit a lower dimentional representation of the binary matrix using logistic SVD
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic SVD on it
lsvd = logisticSVD(mat, k = 1, main_effects = FALSE, use_irlba = FALSE)

# construct fitted probability matrix
fit = fitted(lsvd, type = "response")
}

