% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_logs}
\alias{read_logs}
\title{Return log file as an R data frame}
\usage{
read_logs(logfile = get_logfile(), unsanitizer = default_ndjson_unsanitizer)
}
\arguments{
\item{logfile}{Path to log file.}

\item{unsanitizer}{\link[=sanitizers]{Unsanitizer function} to run over elements in log.
Defaults to \code{\link[=default_ndjson_unsanitizer]{default_ndjson_unsanitizer()}}}
}
\value{
A \code{data.frame}.
}
\description{
This function returns a \code{data.frame} containing all the logs in the provided \code{ndjson} log file.
}
\examples{
  set_logfile(file.path(tempdir(), "loggit.log"), confirm = FALSE)
  message("Test log message")
  read_logs()

}
