% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{grayscale_by_log_level}
\alias{grayscale_by_log_level}
\title{Render a string with light/dark gray based on the related log level}
\usage{
grayscale_by_log_level(msg, level)
}
\arguments{
\item{msg}{string}

\item{level}{see \code{\link{log_levels}}}
}
\value{
string with ANSI escape code
}
\description{
Adding color to a string to be used in terminal output. Supports ANSI standard colors 8 or 256.
}
\examples{
\dontrun{
cat(grayscale_by_log_level(FATAL, 'foobar'), '\\n')
cat(grayscale_by_log_level(ERROR, 'foobar'), '\\n')
cat(grayscale_by_log_level(WARN, 'foobar'), '\\n')
cat(grayscale_by_log_level(SUCCESS, 'foobar'), '\\n')
cat(grayscale_by_log_level(INFO, 'foobar'), '\\n')
cat(grayscale_by_log_level(DEBUG, 'foobar'), '\\n')
cat(grayscale_by_log_level(TRACE, 'foobar'), '\\n')
}
}
