% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{maxPartialSumd}
\alias{maxPartialSumd}
\title{Maximum of the partial sum [probability] [iid]}
\usage{
maxPartialSumd(k, score_probabilities, sequence_min, sequence_max)
}
\arguments{
\item{k}{value at which calculates the probability}

\item{score_probabilities}{the probabilities for each unique score from lowest to greatest}

\item{sequence_min}{minimum score}

\item{sequence_max}{maximum score}
}
\value{
A double representing the probability of the maximum of the partial sum process equal to k
}
\description{
Calculates the distribution of the maximum of the partial sum process for a given value in the identically and independently distributed model
}
\details{
Implement the formula (4) of the article Mercier, S., Cellier, D., & Charlot, D. (2003). An improved approximation for assessing the statistical significance of molecular sequence features. Journal of Applied Probability, 40(2), 427-441. doi:10.1239/jap/1053003554 \cr
Important note : the calculus of the parameter of the distribution uses
the resolution of a polynome which is a function of the score distribution, of order max(score)-min(score). There exists only empirical methods to solve a polynome of order greater that 5
with no warranty of reliable solution.
The found roots are checked internally to the function and an error message is throw in case of inconsistency.
}
\examples{
maxPartialSumd(10, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
}
