% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcc}
\alias{mcc}
\title{MCC [p-value] [iid]}
\usage{
mcc(
  localScore,
  sequence_length,
  score_probabilities,
  sequence_min,
  sequence_max
)
}
\arguments{
\item{localScore}{the observed local score}

\item{sequence_length}{length of the sequence (up to one hundred)}

\item{score_probabilities}{the probabilities for each unique score from lowest to greatest}

\item{sequence_min}{minimum score}

\item{sequence_max}{maximum score}
}
\value{
A double representing the probability of a local score as high as the one given as argument
}
\description{
Calculates an approximated p-value for a given local score value and a medium to long sequence length in the identically and independantly distributed model
}
\details{
This methods is actually an improved method of Karlin and produces more precise results. It should be privileged whenever possible. \cr
As with karlin, the method works the better the longer the sequence.
}
\examples{
mcc(40, 100, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
mcc(40, 10000, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
}
