% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{generate_parallel}
\alias{generate_parallel}
\title{Generate Text in Parallel for Multiple Prompts}
\usage{
generate_parallel(
  context,
  prompts,
  max_tokens = 100L,
  top_k = 40L,
  top_p = 1,
  temperature = 0,
  repeat_last_n = 0L,
  penalty_repeat = 1,
  seed = 1234L,
  progress = FALSE,
  clean = FALSE
)
}
\arguments{
\item{context}{A context object created with \code{\link{context_create}}}

\item{prompts}{Character vector of input text prompts}

\item{max_tokens}{Maximum number of tokens to generate (default: 100)}

\item{top_k}{Top-k sampling parameter (default: 40). Limits vocabulary to k most likely tokens}

\item{top_p}{Top-p (nucleus) sampling parameter (default: 1.0). Cumulative probability threshold for token selection}

\item{temperature}{Sampling temperature (default: 0.0). Set to 0 for greedy decoding. Higher values increase creativity}

\item{repeat_last_n}{Number of recent tokens to consider for repetition penalty (default: 0). Set to 0 to disable}

\item{penalty_repeat}{Repetition penalty strength (default: 1.0). Values >1 discourage repetition. Set to 1.0 to disable}

\item{seed}{Random seed for reproducible generation (default: 1234). Use positive integers for deterministic output}

\item{progress}{If \code{TRUE}, displays a console progress bar indicating batch
completion status while generations are running (default: FALSE).}

\item{clean}{If TRUE, remove common chat-template control tokens from each generated text (default: FALSE).}
}
\value{
Character vector of generated texts
}
\description{
Generate Text in Parallel for Multiple Prompts
}
