% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_mte_tilde.R
\name{eval_mte_tilde}
\alias{eval_mte_tilde}
\title{Evaluate Marginal Treatment Effects Projected onto the Propensity Score}
\usage{
eval_mte_tilde(object, p, u)
}
\arguments{
\item{object}{An object of class \code{mte} returned by \code{\link{mte}}.}

\item{p}{Value(s) of the propensity score \eqn{p} at which MTE_tilde(p, u) is evaluated.}

\item{u}{Value(s) of the latent resistance \eqn{u} at which MTE_tilde(p, u) is evaluated.}
}
\value{
A list of two elements.
  \item{mte_tilde}{Estimates of MTE_tilde(p, u)}
  \item{model}{Fitted model of \eqn{X'(\beta_1 - \beta_0)} as a function of the (estimated)
   propensity score}
}
\description{
\code{eval_mte_tilde} is a function that evaluates marginal treatment effects
projected onto the estimated propensity score (Zhou and Xie 2019). The projection
is done via the function \code{\link[mgcv]{gam}} with default parameters.
}
\examples{
mte_fit <- mte(selection = d ~ x + z, outcome = y ~ x,
  method = "localIV", data = toydata)

x <- seq(0.05, 0.95, 0.05)
mte_tilde_p <- eval_mte_tilde(mte_fit, p = x, u = 0.5)$mte_tilde
mte_tilde_u <- eval_mte_tilde(mte_fit, p = 0.5, u = x)$mte_tilde
mprte_tilde_p <- eval_mte_tilde(mte_fit, p = x, u = x)$mte_tilde

out <- cbind(mte_tilde_p, mte_tilde_u, mprte_tilde_p)
matplot(x = x, y = out, type = "l")

}
\references{
Zhou, Xiang and Yu Xie. 2019. "Marginal Treatment Effects from
  A Propensity Score Perspective." Journal of Political Economy.
}
