% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{loadflux-features}
\alias{loadflux-features}
\alias{feat_event}
\title{Calculate features of a `tsibble` object in conjunction with [features()]}
\usage{
feat_event(x)
}
\arguments{
\item{x}{A vector to extract features from.}
}
\description{
You can calculate a series of summary statistics (features) of a given
  variable for a dataset. For example, a three number summary, the minimum,
  median, and maximum, can be calculated for a given variable. This is
  designed to work with the [features()] function shown in the examples.
  Other available features in `loadflux` include:
}
\examples{

# You can use any of the features `feat_*` in conjunction with `features`
# like so:
library(dplyr)
library(fabletools)
library(tsibble)

djants <- djan \%>\%
  hydro_events(
    q = discharge,
    datetime = time,
    window = 21
  ) \%>\%
  as_tsibble(
    key = he,
    index = time
  )

djants \%>\%
  features(
    time, # variable you want to explore
    feat_event
  ) # the feature summarisation you want to perform
}
