% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk-writer.r
\name{listdown}
\alias{listdown}
\title{Create a listdown Object}
\usage{
listdown(
  package = NULL,
  decorator = list(),
  decorator_chunk_opts = list(),
  default_decorator = identity,
  setup_expr = NULL,
  init_expr = NULL,
  load_cc_expr = NULL,
  ...,
  chunk_opts = NULL
)
}
\arguments{
\item{package}{a quoted list of package required by the outputted document.}

\item{decorator}{a named list mapping the potential types of list elements
to a decorator function.}

\item{decorator_chunk_opts}{a named list mapping the potential types of list
elements to chunk options that should be included for those types.}

\item{default_decorator}{the decorator to use for list elements whose type
is not inherited from the decorator list. If NULL then the those
elements will not be included when the chunks are written. By default
this is identity, meaning that the elements will be passed directly
(through the identity() function).}

\item{setup_expr}{an expression that is added before package are 
loaded. The expression is put into a chunk named `setup` with option
`include = FALSE` and is intended for initializing the document. For
example the expression `knitr::opts_chunk$set(echo = FALSE)` could be
used to turn echo'ing off for the entire document.}

\item{init_expr}{an initial expression that will be added to the outputted
document after the libraries have been called. This expression appears
after packages are loaded and before data is read.}

\item{load_cc_expr}{either an unquoted expression or a character string
that will be turned into an unquoted expression via str2lang to load the 
presentation list.}

\item{...}{default options sent to the chunks of the outputted document.}

\item{chunk_opts}{a named list of options sent to the chunks of outputted
documents. Note: takes priority over argument provided to ...}
}
\description{
A listdown object provides information for how a presentation
list should be used to create an R Markdown document. It requires an
unquoted expression indicating how the presentation list will be loaded.
In addition, libraries required by the outputted document and other
parameters can be specified.
}
