% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{apply_default_leaflet_behavior}
\alias{apply_default_leaflet_behavior}
\title{Apply Default Leaflet Behavior for Selection Events}
\usage{
apply_default_leaflet_behavior(map_proxy, selected_data, component_info)
}
\arguments{
\item{map_proxy}{A leaflet map proxy object used to update the map}

\item{selected_data}{A data frame or list containing the selected row/item data.
If NULL, indicates deselection occurred.}

\item{component_info}{A list containing component configuration information:
\describe{
\item{shared_id_column}{Character. Name of the column containing unique identifiers}
\item{config}{List containing:
\describe{
\item{lng_col}{Character. Name of the longitude column}
\item{lat_col}{Character. Name of the latitude column}
\item{highlight_zoom}{Numeric. Zoom level to use when highlighting selection}
}
}
}}
}
\value{
Returns the modified map proxy object with updated view and popups
}
\description{
\code{apply_default_leaflet_behavior} is a helper function that provides consistent default behavior for leaflet maps
when handling selection events. It manages popup display and map navigation
based on the selection state.
}
\details{
When \code{selected_data} is provided:
\itemize{
\item Creates a popup with "Selected" header and ID information
\item Sets map view to the selected location coordinates
\item Applies the configured highlight zoom level
}
When \code{selected_data} is NULL (deselection):
\itemize{
\item Removes all existing popups from the map
}
}
