% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{parseOTBFunction}
\alias{parseOTBFunction}
\title{Get OTB function calls}
\usage{
parseOTBFunction(algos = NULL, gili = NULL)
}
\arguments{
\item{algos}{number of the algorithm as provided by `getOTBAlgorithm`}

\item{gili}{optional gis linkage as done by `linkOTB()`}
}
\description{
retrieve the choosen function and parses all arguments with the defaults
}
\examples{
\dontrun{
otbLinks<-link2GI::linkOTB()
path_OTB<-otbLinks$pathOTB


## parse all modules
algo<-parseOTBAlgorithms(gili = otbLinks)


## take edge detection
otb_algorithm<-algo[27]
algo_cmd<-parseOTBFunction(algo = otb_algorithm,gili = otbLinks)
## print the current command
print(algo_cmd)

### usecase

## link to OTB
otblink<-link2GI::linkOTB()
path_OTB<-otblink$pathOTB

## get data
setwd(tempdir())
## get some typical data as provided by the authority
url<-"http://www.ldbv.bayern.de/file/zip/5619/DOP\%2040_CIR.zip"
res <- curl::curl_download(url, "testdata.zip")
unzip(res,junkpaths = TRUE,overwrite = TRUE)

## get all modules
algo<-parseOTBAlgorithms(gili = otblink)

## use edge detection
otb_algorithm<-algo[27]
algo_cmd<-parseOTBFunction(algo = algo[27],gili = otblink)



## set arguments
algo_cmd$`-progress`<-1
algo_cmd$`-in`<- file.path(getwd(),"4490600_5321400.tif")
algo_cmd$`-filter`<- "sobel"

## create out name
outName<-paste0(getwd(),"/out",algo_cmd$`-filter`,".tif")
algo_cmd$`-out`<- outName

if (filter == "touzi") {
  algo_cmd$`-filter.touzi.xradius`<- filter.touzi.xradius
  algo_cmd$`-filter.touzi.yradius`<- filter.touzi.yradius
}


## generate basic command 
command<-paste0(path_OTB,"otbcli_",otb_algorithm," ")
## generate full command
command<-paste(command,paste(names(algo_cmd),algo_cmd,collapse = " "))

## make the system call
system(command,intern = TRUE)

##create raster
retStack<-assign(outName,raster::raster(outName))


## plot raster
raster::plot(retStack)
} 

}
