% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.locallod.R
\name{calc.locallod}
\alias{calc.locallod}
\title{Calculate LOD score at physical position of each gene}
\usage{
calc.locallod(cross, pheno, pmark, addcovar = NULL, intcovar = NULL,
  verbose = TRUE, n.cores = 1)
}
\arguments{
\item{cross}{An object of class \code{"cross"} containing data for a QTL
experiment.  See the help file for \code{\link[qtl]{read.cross}} in the
R/qtl package (\url{http://www.rqtl.org}).  There must be a phenotype named
\code{"id"} or \code{"ID"} that contains the individual identifiers.}

\item{pheno}{A data frame of phenotypes (generally gene expression data),
stored as individuals x phenotypes.  The row names must contain individual
identifiers.}

\item{pmark}{Pseudomarkers that are closest to the genes in \code{pheno}, as
output by \code{\link{find.gene.pseudomarker}}.}

\item{addcovar}{Additive covariates passed to \code{\link{scanone}}.}

\item{intcovar}{Interactive covariates passed to \code{\link{scanone}}.}

\item{verbose}{If TRUE, print tracing information.}

\item{n.cores}{Number of CPU cores to use in the calculations. With
\code{n.cores=0}, \code{\link[parallel]{detectCores}} is used to
detect the number of available cores.}
}
\value{
A vector of LOD scores.  The names indicate the gene names (columns in
\code{pheno}).
}
\description{
For gene expression data with physical positions of the genes, calculate the
LOD score at those positions to assess evidence for local eQTL.
}
\details{
\code{cross} and \code{pheno} must contain exactly the same individuals in
the same order.  (Use \code{\link{findCommonID}} to line them up.)

We consider the expression phenotypes in batches: those whose closest
pseudomarker is the same.

We use Haley-Knott regression to calculate the LOD scores.

Actually, we use a bit of a contortion of the data to force the
\code{\link[qtl]{scanone}} function in R/qtl to calculate the LOD score at a
single position.

We omit any transcripts that map to the X chromosome; we can only handle
autosomal loci for now.
}
\examples{
data(f2cross, expr1, genepos, pmap)
library(qtl)
\dontshow{
n_ind <- 20
n_genes <- 5
f2cross <- f2cross[,1:n_ind]
expr1 <- expr1[1:n_ind,1:n_genes]
genepos <- genepos[1:n_genes,]}
# calc QTL genotype probabilities
f2cross <- calc.genoprob(f2cross, step=1)

# find nearest pseudomarkers
pmark <- find.gene.pseudomarker(f2cross, pmap, genepos, "prob")

# line up f2cross and expr1
id <- findCommonID(f2cross, expr1)

# calculate LOD score for local eQTL
locallod <- calc.locallod(f2cross[,id$first], expr1[id$second,], pmark)

}
\seealso{
\code{\link{find.gene.pseudomarker}}, \code{\link{plotEGclass}},
\code{\link{findCommonID}}, \code{\link{disteg}}
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\keyword{utilities}
