% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPlikelihoods.R
\name{constrlogLikFun}
\alias{constrlogLikFun}
\title{Log-Constrained-Likelihood of a Gaussian Process.}
\usage{
constrlogLikFun(par = model$kernParam$par, model, parfixed = NULL,
  mcmc.opts = list(probe = c("Genz"), nb.mcmc = 1000),
  estim.varnoise = FALSE)
}
\arguments{
\item{par}{the values of the covariance parameters.}

\item{model}{an object with \code{"lineqGP"} S3 class.}

\item{parfixed}{not used.}

\item{mcmc.opts}{mcmc options. \code{mcmc.opts$probe} A character string corresponding
to the estimator for the orthant multinormal probabilities.
Options: \code{"Genz"} (Genz, 1992), \code{"ExpT"} (Botev, 2017).
If \code{probe == "ExpT"}, \code{mcmc.opts$nb.mcmc}  is the number of MCMC
samples used for the estimation.}

\item{estim.varnoise}{If \code{true}, a noise variance is estimated.}
}
\value{
The value of the negative log-constrained-likelihood.
}
\description{
Compute the negative log-constrained-likelihood of a Gaussian Process
conditionally to the inequality constraints (Lopez-Lopera et al., 2018).
}
\details{
Orthant multinormal probabilities are estimated according to
(Genz, 1992; Botev, 2017). See (Lopez-Lopera et al., 2018).
}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2018),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{SIAM/ASA Journal on Uncertainty Quantification}, 6(3): 1224-1255.
\href{https://doi.org/10.1137/17M1153157}{[link]}

Bachoc, F., Lagnoux, A., and Lopez-Lopera, A. F. (2018),
"Maximum likelihood estimation for Gaussian processes under inequality constraints".
\emph{ArXiv e-prints}
\href{https://arxiv.org/abs/1804.03378}{[link]}

Genz, A. (1992),
"Numerical computation of multivariate normal probabilities".
\emph{Journal of Computational and Graphical Statistics},
1:141-150.
\href{https://www.tandfonline.com/doi/abs/10.1080/10618600.1992.10477010}{[link]}

Botev, Z. I. (2017),
"The normal law under linear restrictions: simulation and estimation via minimax tilting".
\emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)},
79(1):125-148.
\href{https://rss.onlinelibrary.wiley.com/doi/pdf/10.1111/rssb.12162}{[link]}
}
\seealso{
\code{\link{constrlogLikGrad}}, \code{\link{logLikFun}},
         \code{\link{logLikGrad}}
}
\author{
A. F. Lopez-Lopera.
}
