% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{get_x}
\alias{get_x}
\title{get x (left hand of var) from model or formula}
\usage{
get_x(model, method = c("raw", "model", "coeff"), data = NULL)
}
\arguments{
\item{model}{a formula or a model.}

\item{method}{either \code{'raw','model'}, or \code{'coeff'}, to decide what kind variables to show.
Default is 'raw'. See section Detials below.}

\item{data}{a dataframe, to provide new data to evaluate the model. If NULL (default), then we use the default data in the model.}
}
\value{
x variables in the formula or model
}
\description{
get x (left hand of var) from model or formula
}
\details{
What do 'raw' variable, 'model' variable, and 'coeff' variable mean?

\itemize{
\item raw var is the underlying variable without any calculation or transformation.
\item model var is the underlying variable with calculations or transformation.
\item coeff var is the coefficient variable in the model output.
     So only evaluated model has coeff vars.
     Most of the time one categorical variable will have several coeff vars according to their contrast encoding. see \code{\link{get_contrast}}
}

Example:

In the model, \code{log(price) ~ cut + I(carat^2)} in \code{diamonds} data, we have:
\itemize{
\item 'raw' variables of x: \code{carat} and \code{cut}.
\item 'model' variables of x: \code{I(carat^2)} and \code{cut}.
\item 'coeff' variables of x: \code{cut.L,"cut.Q","cut.C","cut^4"} and \code{I(carat^2)}.
}

See the sample code below for more examples.
}
\examples{

# use the sample code from get_x_hidden
#
data = ggplot2::diamonds
diamond_lm  =  lm(price~  I(carat^   2) + cut  + carat*table ,ggplot2::diamonds)

#_________ input as model
get_x(model = diamond_lm,method = 'raw')
get_x(diamond_lm,method = 'model')
get_x(diamond_lm,method = 'coeff')

#_______ input as formula
get_x(formula(diamond_lm),method = 'model')
# data is required when input is formula
get_x(formula(diamond_lm), data = ggplot2::diamonds, method = 'coeff')

tryCatch(
  get_x(formula(diamond_lm),method = 'coeff'),
  error =function(err){
    print(err)
  }
)



#________ irregular formulas __________

model_dirty = model = lm(price~  I(carat^   2) + cut  - carat:table - cut ,ggplot2::diamonds)

# CORRECT for raw vars
get_x(model_dirty)

# correct for model vars
get_x(price~  I(carat^2) + cut  - carat:table - cut,data = ggplot2::diamonds, method ='model')
get_x(model_dirty,method = 'model')
get_x(model_dirty,data = ggplot2::diamonds, method = 'model')
get_x(model_dirty, method = 'model')

# clean method for model vars
# terms((price~  I(carat^2) + cut  - carat:table - cut)) \%>\% attr(.,"factors") \%>\% colnames()
# model_dirty \%>\% terms \%>\% attr(.,"factors") \%>\% colnames()
# formula(model_dirty) \%>\% terms \%>\% attr(.,"factors") \%>\% colnames()

}

