% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lime-package.r
\docType{package}
\name{lime-package}
\title{lime - Local, Interpretable, Model-Agnostic, Explanations}
\description{
This package is a port of the original Python lime package implementing the
prediction explanation framework laid out Ribeiro \emph{et al.} (2016). The
package supports models from \code{caret} and \code{mlr} natively, but see
\link[=model_support]{the docs} for how to make it work for any model.
}
\section{Main functions}{

Use of \code{lime} is mainly through two functions. First you create an
\code{explainer} object using the \code{\link[=lime]{lime()}} function based on the training data and
the model, and then you can use the \code{\link[=explain]{explain()}} function along with new data
and the explainer to create explanations for the model output.

Along with these two functions, \code{lime} also provides the \code{\link[=plot_features]{plot_features()}}
and \code{\link[=plot_text_explanations]{plot_text_explanations()}} function to visualise the explanations
directly.
}

\references{
Ribeiro, M.T., Singh, S., Guestrin, C. \emph{"Why Should I Trust You?": Explaining the Predictions of Any Classifier}. 2016, \url{https://arxiv.org/abs/1602.04938}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/thomasp85/lime}
  \item Report bugs at \url{https://github.com/thomasp85/lime/issues}
}

}
\author{
\strong{Maintainer}: Thomas Lin Pedersen \email{thomasp85@gmail.com}

Authors:
\itemize{
  \item Michaël Benesty \email{michael@benesty.fr}
}

}
