% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backward_compatibility.R
\name{old_spatial_packages}
\alias{old_spatial_packages}
\alias{as.spatial}
\alias{as.spatial.LAS}
\alias{as.spatial.LAScatalog}
\alias{tree_metrics}
\alias{grid_canopy}
\alias{grid_density}
\alias{grid_terrain}
\alias{grid_metrics}
\alias{find_trees}
\alias{delineate_crowns}
\title{Older R Spatial Packages}
\usage{
as.spatial(x)

\method{as.spatial}{LAS}(x)

\method{as.spatial}{LAScatalog}(x)

tree_metrics(las, func = ~list(Z = max(Z)), attribute = "treeID", ...)

grid_canopy(las, res, algorithm)

grid_density(las, res = 4)

grid_terrain(
  las,
  res = 1,
  algorithm,
  ...,
  keep_lowest = FALSE,
  full_raster = FALSE,
  use_class = c(2L, 9L),
  Wdegenerated = TRUE,
  is_concave = FALSE
)

grid_metrics(
  las,
  func,
  res = 20,
  start = c(0, 0),
  filter = NULL,
  by_echo = "all"
)

find_trees(las, algorithm, uniqueness = "incremental")

delineate_crowns(
  las,
  type = c("convex", "concave", "bbox"),
  concavity = 3,
  length_threshold = 0,
  func = NULL,
  attribute = "treeID"
)
}
\arguments{
\item{x, las}{an object of class LAS*}

\item{func}{see \link{template_metrics}}

\item{attribute, type}{see \link{crown_metrics}}

\item{...}{ignored}

\item{res, start}{see \link{pixel_metrics}}

\item{algorithm}{see \link{rasterize_canopy}, \link{rasterize_terrain}}

\item{full_raster, use_class, Wdegenerated, is_concave, keep_lowest}{see \link{rasterize_density}}

\item{filter, by_echo}{see \link{template_metrics}}

\item{uniqueness}{see \link{crown_metrics}}

\item{concavity, length_threshold}{see \link{concaveman}}
}
\description{
lidR 4.0.0 no longer uses the \code{sp} and \code{raster} packages. New functions are based on \code{sf}, \code{terra} and \code{stars}.
However, to maintain backward compatibility the old functions from v<4.0.0 were preserved.\cr\cr
\code{rgdal} and \code{rgeos} will be retired on Jan 1st 2024. The \code{raster} and \code{sp} packages are based on
\code{rgdal} and \code{rgeos}. \code{lidR} was based on \code{raster} and \code{sp} because it was created before the \code{sf}, \code{terra}
and \code{stars} packages. This means that sooner or later users and packages that are still based on
old R spatial packages will run into trouble. According to Edzer Pebesma, Roger Bivand: \cr\cr
\emph{R users who have been around a bit longer, in particular before packages like \code{sf} and \code{stars} were
developed, may be more familiar with older packages like \code{maptools}, \code{sp}, \code{rgeos}, and \code{rgdal}. A fair
question is whether they should migrate existing code and/or existing R packages depending on these
packages. The answer is: yes (see reference).}\cr\cr
The following functions are not formally deprecated but users should definitely move their workflow to modern
spatial packages. lidR will maintain the old functions as long as it does not generate issues
on CRAN. So, it might be until Jan 1st 2024 or later, who knows...
}
\references{
Edzer Pebesma, Roger Bivand Spatial Data Science with applications in R
https://keen-swartz-3146c4.netlify.app/older.html
}
