% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.r
\name{tree_detection}
\alias{tree_detection}
\title{Individual tree detection}
\usage{
tree_detection(las, algorithm)
}
\arguments{
\item{las}{An object of class \code{LAS} or \code{LAScatalog}. Can also be a \code{RasterLayer}
representing a canopy height model, in which case it is processed like a regularly-spaced point cloud.}

\item{algorithm}{An algorithm for individual tree detection. lidR has: \link{lmf} and \link{manual}.
More experimental algorithms may be found in the package \href{https://github.com/Jean-Romain/lidRplugins}{lidRplugins}.}
}
\value{
A SpatialPointsDataFrame with an attribute Z for the tree tops and treeID with an individual
ID for each tree.
}
\description{
Individual tree detection function that find the position of the trees using several possible
algorithms.
}
\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} (in bold). For more details see the
\link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item \strong{chunk size}: How much data is loaded at once.
\item \strong{chunk buffer*}: Mandatory to get a continuous output without edge effects. The buffer is
always removed once processed and will never be returned either in R or in files.
\item \strong{chunk alignment}: Align the processed chunks.
\item \strong{cores}: How many cores are used.
\item \strong{progress}: Displays a progression estimation.
\item \strong{output_files}: Supported templates are \code{\{XLEFT\}}, \code{\{XRIGHT\}},
\code{\{YBOTTOM\}}, \code{\{YTOP\}}, \code{\{XCENTER\}}, \code{\{YCENTER\}} \code{\{ID\}} and,
if chunk size is equal to 0 (processing by file), \code{\{ORIGINALFILENAME\}}.
\item \strong{laz_compression}: write \code{las} or \code{laz} files
\item select: The function will write files equivalent to the original ones. Thus \code{select = "*"}
and cannot be changed.
\item \strong{filter}: Read only points of interest.
}
}

\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")

ttops <- tree_detection(las, lmf(ws = 5))

x = plot(las)
add_treetops3d(x, ttops)
}
