% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lascheck.r
\name{lascheck}
\alias{lascheck}
\title{Inspect a LAS object}
\usage{
lascheck(las)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}
}
\description{
Performs a deep inspection of a LAS or LAScatalog object and prints a report.\cr\cr
For a LAS object it checks:
\itemize{
\item if the point cloud is valid according to las specification
\item if the header is valid according to las specification
\item if the point cloud is in accordance with the header
\item if the point cloud has duplicated points and degenerated ground points
\item it the coordinate reference sytem is correctly recorded
\item if some pre-processing, such as normalization or ground filtering, is already done.
}
For a LAScatalog object it checks:
\itemize{
\item if the headers are consistent across files
\item if the files are overlapping
\item if some pre-processing, such as normalization, is already done.
}
For the pre-processing tests the function only makes an estimation and may not be correct.
}
