% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_gases.R
\name{list_gases}
\alias{list_gases}
\title{lists gases present in the dataset}
\usage{
list_gases(df, file_type = "auto", file_type_list = c("82z", "81x", "auto"))
}
\arguments{
\item{df}{the dataframe as imported with \link[licoread:licoread]{licoread}}

\item{file_type}{type of file (currently works only for 82z). If "auto"
(default), the function will try to detect it by itself.}

\item{file_type_list}{list of file types}
}
\value{
a character vector of the gases present in the dataset
}
\description{
prints a character vector of the gases present in the dataset.
This is to be used to obtain the exact names of the gases before using
\link[licoread:licoread_to_fluxible]{licoread_to_fluxible}.
}
\examples{
path_82z <- system.file("extdata/82z", package = "licoread")
gas_df_82z <- licoread(path_82z)
list_gases(gas_df_82z)
}
