% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{check_attached}
\alias{check_attached}
\title{Check if packages are attached}
\usage{
check_attached(...)
}
\arguments{
\item{...}{(Dots) Package names as bare names, strings, or a character vector.
If left empty, lists all attached packages.}
}
\value{
If \code{dots} is empty, a character vector of all attached packages.
Otherwise, return a named logical vector where \code{TRUE} means the package
is attached
}
\description{
Check if packages are attached
}
\examples{
\dontrun{
check_attached()

#>   [1] "librarian" "testthat"  "magrittr"  "stats" ...

check_attached(c("utils", "stats"))

#> utils stats 
#> TRUE  TRUE 

check_attached("datasets", "base", fakepkg)

#> datasets     base  fakepkg 
#>     TRUE     TRUE    FALSE 
}

}
