% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_remove}
\alias{lib_remove}
\title{Remove Data from a Data Library}
\usage{
lib_remove(x, name)
}
\arguments{
\item{x}{The data library.}

\item{name}{The quoted name of the item to remove from the data library. 
For more than one name, pass a vector of quoted names.}
}
\value{
The library with the requested item removed.
}
\description{
The \code{lib_remove} function removes an item from the 
data library, and deletes the source file for that data.  If the library
is loaded, it will also remove that item from the workspace environment.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Add data to the library
lib_add(dat, mtcars, beaver1, iris)
# library 'dat': 3 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#      Name Extension Rows Cols   Size        LastModified
# 1  mtcars       rds   32   11 7.5 Kb 2020-11-05 19:32:00
# 2 beaver1       rds  114    4 5.1 Kb 2020-11-05 19:32:04
# 3    iris       rds  150    5 7.5 Kb 2020-11-05 19:32:08

# Remove items from the library
lib_remove(dat, c("beaver1", "iris"))
# library 'dat': 1 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#     Name Extension Rows Cols   Size        LastModified
# 1 mtcars       rds   32   11 7.5 Kb 2020-11-05 19:32:40

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
