% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marc-field-deconstruction.R
\name{marc_008_get_info}
\alias{marc_008_get_info}
\title{Get info from MARC control field 008}
\usage{
marc_008_get_info(
  x,
  original.pub.date = TRUE,
  include.questionable.dates = FALSE
)
}
\arguments{
\item{x}{A string (or vector of strings) of LCCNs}

\item{original.pub.date}{If \code{TRUE} (default) and if applicable,
return the original publication date, not
the re-issue publication date}

\item{include.questionable.dates}{A logical indicating whether "questionable"
dates should be replaced with \code{NA}}
}
\value{
A \code{data.table}
}
\description{
Takes one or more MARC 008 fields (string/strings) and returns a
\code{data.table} containing the publication date, publication
place code, and language code.
}
\examples{

# The Brothers Karamazov (1970 reissue but original publication date)
marc_008_get_info("950622r19701880ru            000 0 rus d")
#    pub_date pub_place_code lang_code
#       <int>         <char>    <char>
# 1:     1880             ru       rus

# reissue publication date
marc_008_get_info("950622r19701880ru            000 0 rus d",
                  original.pub.date=FALSE)
#     pub_date pub_place_code lang_code
#        <int>         <char>    <char>
#  1:     1970             ru       rus

# vectorized
marc_008_get_info(c("101106s1992    gr            000 1 gre d", NA,
                    "180528s2017    ag            000 j spa d"))
#      pub_date pub_place_code lang_code
#         <int>         <char>    <char>
#   1:     1992             gr       gre
#   2:       NA           <NA>      <NA>
#   3:     2017             ag       spa

}
