% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{normalize_isbn_13}
\alias{normalize_isbn_13}
\title{Attempt to enforce validity and canonical form to ISBN 13}
\usage{
normalize_isbn_13(x, aggressive = TRUE)
}
\arguments{
\item{x}{A string}

\item{aggressive}{A logical indicating whether aggressive measures
should be taken to try to get the "ISBN 13"
into a valid form. See "Details" for more info}
}
\value{
Returns valid ISBN 13 if possible, NA if not
}
\description{
Takes a string representation of an ISBN 13. Strips all non-digit
characters and checks if it is valid (whether the
check digit works out, etc). User can specify whether "aggressive"
measures should be taken to salvage the malformed ISBN 13 string.
}
\details{
If \code{aggressive} is TRUE, aggressive measures are taken to
try to salvage the malformed ISBN 13 string. If the ISBN 13, for example,
is more than 13 characters, this function will attempt to make a valid
ISBN 13 from the first 13 digits.
}
\examples{

normalize_isbn_13("978966819^*!X7918")        # "9789668197918"

# vectorized
normalize_isbn_13(c("978-9-66-819791-8", "__9__781572411579"))
# "9789668197918" "9781572411579"

}
\seealso{
\code{\link{normalize_isbn}} \code{\link{normalize_isbn_10}}
}
