% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optSeededLHS.R
\name{optSeededLHS}
\alias{optSeededLHS}
\title{Optimum Seeded Latin Hypercube Sample}
\usage{
optSeededLHS(seed, m = 0, maxSweeps = 2, eps = 0.1,
  verbose = FALSE)
}
\arguments{
\item{seed}{The number of partitions (simulations or design points)}

\item{m}{The number of additional points to add to the seed matrix \code{seed}.  default value is zero.  If m is zero then the seed design is optimized.}

\item{maxSweeps}{The maximum number of times the CP algorithm is applied to all the columns.}

\item{eps}{The optimal stopping criterion}

\item{verbose}{Print informational messages}
}
\value{
An \code{n} by \code{k} Latin Hypercube Sample matrix with values uniformly distributed on [0,1]
}
\description{
Augments an existing Latin Hypercube Sample, adding points to the design, while
maintaining the \emph{latin} properties of the design.  This function then uses the
columnwise pairwise (\acronym{CP}) algoritm to optimize the design.  The original design is not necessarily maintained.
}
\details{
Augments an existing Latin Hypercube Sample, adding points to the design, while
maintaining the \emph{latin} properties of the design.  This function then uses the
\acronym{CP} algoritm to optimize the design.  The original design
is not necessarily maintained.
}
\examples{
  a <- randomLHS(4,3)
  a
  optSeededLHS(a, 2, 2, .1)
}
\references{
Stein, M.  (1987) Large Sample Properties of Simulations Using Latin Hypercube Sampling.
  \emph{Technometrics}. \bold{29}, 143--151.
}
\seealso{
[randomLHS()], [geneticLHS()], [improvedLHS()], [maximinLHS()], and
[optimumLHS()] to generate Latin Hypercube Samples.  [optAugmentLHS()] and
[augmentLHS()] to modify and augment existing designs.
}
\keyword{design}
