% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderElasticSearch.R
\name{AppenderElasticSearch}
\alias{AppenderElasticSearch}
\title{Log to ElasticSearch}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
Log to ElasticSearch via HTTP
}
\details{
\strong{NOTE}: \strong{Experimental}; not yet fully documented and and details are
subject to change
}
\seealso{
Other Appenders: 
\code{\link{AppenderDbi}},
\code{\link{AppenderDt}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSendmail}},
\code{\link{AppenderSyslog}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderMemory]{lgr::AppenderMemory}} -> \code{AppenderElasticSearch}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{conn}}{a \link[elastic:connect]{ElasticSearch connection}}

\item{\code{close_on_exit}}{\code{TRUE} or \code{FALSE}. Close the ElasticSearch connection
when the Logger is removed?}

\item{\code{index}}{a \code{character} scalar or a \link[DBI:Id]{DBI::Id} specifying the target
ElasticSearch index}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderElasticSearch$new()}}
\item \href{#method-set_close_on_exit}{\code{AppenderElasticSearch$set_close_on_exit()}}
\item \href{#method-set_conn}{\code{AppenderElasticSearch$set_conn()}}
\item \href{#method-get_data}{\code{AppenderElasticSearch$get_data()}}
\item \href{#method-show}{\code{AppenderElasticSearch$show()}}
\item \href{#method-flush}{\code{AppenderElasticSearch$flush()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="append">}\href{../../lgr/html/AppenderMemory.html#method-append}{\code{lgr::AppenderMemory$append()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="clear">}\href{../../lgr/html/AppenderMemory.html#method-clear}{\code{lgr::AppenderMemory$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="format">}\href{../../lgr/html/AppenderMemory.html#method-format}{\code{lgr::AppenderMemory$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_buffer_size">}\href{../../lgr/html/AppenderMemory.html#method-set_buffer_size}{\code{lgr::AppenderMemory$set_buffer_size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_exit">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_on_exit}{\code{lgr::AppenderMemory$set_flush_on_exit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_rotate">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_on_rotate}{\code{lgr::AppenderMemory$set_flush_on_rotate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_threshold">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_threshold}{\code{lgr::AppenderMemory$set_flush_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_should_flush">}\href{../../lgr/html/AppenderMemory.html#method-set_should_flush}{\code{lgr::AppenderMemory$set_should_flush()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderElasticSearch$new(
  conn,
  index,
  threshold = NA_integer_,
  layout = LayoutElasticSearch$new(),
  close_on_exit = TRUE,
  buffer_size = 0,
  flush_threshold = "error",
  flush_on_exit = TRUE,
  flush_on_rotate = TRUE,
  should_flush = NULL,
  filters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn, index}}{see section \emph{Fields}}

\item{\code{threshold, flush_threshold, layout, buffer_size}}{see \link{AppenderBuffer}
A data \code{data.frame}. content of index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_close_on_exit"></a>}}
\if{latex}{\out{\hypertarget{method-set_close_on_exit}{}}}
\subsection{Method \code{set_close_on_exit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderElasticSearch$set_close_on_exit(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_conn"></a>}}
\if{latex}{\out{\hypertarget{method-set_conn}{}}}
\subsection{Method \code{set_conn()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderElasticSearch$set_conn(conn)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-get_data}{}}}
\subsection{Method \code{get_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderElasticSearch$get_data(
  n = 20L,
  threshold = NA,
  result_type = "data.frame"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{integer} scalar. Retrieve only the last \code{n} log entries that match
\code{threshold}}

\item{\code{threshold}}{\code{character} or \code{integer} scalar. The minimum log level
that should be displayed}

\item{\code{result_type}}{\code{character} scalar. Any of:
\itemize{
\item \code{data.frame}
\item \code{data.table} (shortcut: \code{dt})
\item \code{list} (unprocessed list with ElasticSearch metadata)
\item \code{json} (raw ElasticSearch JSON)
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
see \code{result_type}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderElasticSearch$show(threshold = NA_integer_, n = 20)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flush"></a>}}
\if{latex}{\out{\hypertarget{method-flush}{}}}
\subsection{Method \code{flush()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderElasticSearch$flush()}\if{html}{\out{</div>}}
}

}
}
