% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_list.R
\name{event_list}
\alias{event_list}
\alias{as_event_list}
\alias{as_event_list.list}
\alias{as_event_list.LogEvent}
\alias{as_event_list.data.frame}
\alias{as.data.table.event_list}
\alias{as.data.frame.event_list}
\title{A List of LogEvents}
\usage{
event_list(...)

as_event_list(x, ...)

\method{as_event_list}{list}(x, ..., scalarize = FALSE)

\method{as_event_list}{LogEvent}(x, ..., scalarize = FALSE)

\method{as_event_list}{data.frame}(x, na.rm = TRUE, ...)

as.data.table.event_list(x, na.rm = TRUE)

\method{as.data.frame}{event_list}(
  x,
  row.names = NULL,
  optional = FALSE,
  stringsAsFactors = FALSE,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{...}{for \code{event} elements to be added to the list, for the \verb{as_*()}
functions parameters passed on to methods.}

\item{x}{any \code{R} object}

\item{scalarize}{\code{logical} scalar. Turn \link{LogEvents} with non-scalar \code{msg}
field into separate log events}

\item{na.rm}{remove \code{NA} values before coercing a data.frame to an \code{event_list()}.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{currently ignored and only included for compatibility.}

\item{stringsAsFactors}{\code{logical} scalar: should \code{character} vectors be
converted to factors? Defaults to \code{FALSE} (as opposed to
\code{\link[base:as.data.frame]{base::as.data.frame()}}) and is only included for compatibility.}
}
\value{
an \code{event_list()} and \code{as_event_list()} return a flat \code{list}
of \link{LogEvents}. Nested lists get automatically flattened.

\code{as.data.frame} and \code{as.data.table} return a \code{data.frame} or \code{data.table}
respectively
}
\description{
An event_list is a class for \code{list()}s whose only elements are \link{LogEvents}.
This structure is occasionally used internally in lgr (for example by
\link{AppenderBuffer}) and can be useful for developers that want to write
their own Appenders.
}
\details{
For convenience, \code{as.data.frame()} and \code{as.data.table()} methods
exist for event lists.
}
\examples{
e <- LogEvent$new(level = 300, msg = "a", logger = lgr)
as_event_list(e)
as_event_list(c(e, e))
# nested lists get automatically unnested
as_event_list(c(e, list(nested_event = e)))

# scalarize = TRUE "unpacks" events with vector log messages
e <- LogEvent$new(level = 300, msg = c("A", "B"), logger = lgr)
as_event_list(e, scalarize = FALSE)
as_event_list(e, scalarize = TRUE)

}
\seealso{
Other docs relevant for extending lgr: 
\code{\link{LogEvent}},
\code{\link{standardize_threshold}()}
}
\concept{docs relevant for extending lgr}
