% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderDt}
\alias{AppenderDt}
\alias{lgr_data}
\title{Log to an In-Memory Data.Table}
\description{
An Appender that outputs to an in-memory \code{data.table}. This kind of
Appender is useful for interactive use, and has very little overhead.
}
\section{Custom Fields}{


\code{AppenderDt} supports \link[=LogEvent]{custom fields}, but they have to be
pre-allocated in the \code{prototype} argument. Custom fields that are not
part of the prototype are discarded. If you want an Appender that retains
all custom fields (at the cost of slightly less performance), take a look at
\link{AppenderBuffer}.

With the default settings, the custom field \code{value} is included in the
\code{data.table} as a list column to store arbitrary \R objects (see example).
It is recommended to use this feature only \code{TRACE} level.
}

\section{Usage}{
\preformatted{
x <- AppenderDt$new(threshold = NA_integer_, layout = LayoutFormat$new(fmt =
  "\%L [\%t] \%m \%f", timestamp_fmt = "\%H:\%M:\%OS3", colors =
  getOption("lgr.colors", list())), prototype = data.table::data.table(.id =
  NA_integer_, level = NA_integer_, timestamp = Sys.time(), logger =
  NA_character_, caller = NA_character_, msg = NA_character_, .custom =
  list(list())), buffer_size = 1e+05, filters = NULL)

x$add_filter(filter, name = NULL)
x$append(event)
x$filter(event)
x$remove_filter(pos)
x$set_filters(filters)
x$set_layout(layout)
x$set_threshold(level)
x$show(threshold = NA_integer_, n = 20L)

x$data
x$destination
x$dt
x$filters
x$layout
x$threshold

}
}

\section{Creating a Data Table Appender}{


In addition to the usual fields, \code{AppenderDt$new()} requires that you supply
a \code{buffer_size} and a \code{prototype}. These determine the structure of the
\code{data.table} used to store the log this appender creates and cannot be
modified anymore after the instantiation of the appender.

The \link{Layout} for this Appender is used only to format console output of
its \code{$show()} method.

\describe{
\item{buffer_size}{\code{integer} scalar. Number of rows of the in-memory
\code{data.table}}
\item{prototype}{A prototype \code{data.table}. The prototype must be a
\code{data.table} with the same columns and column types as the data
you want to log. The actual content of the columns is irrelevant.
There are a few columns that have special meaning, based on their name:
\itemize{
\item{\code{.id}: \code{integer} (mandatory). Must always be the first column
and is used internally by the Appender}
\item{\code{.custom}: \code{list} (optional). If present all custom values of the
event (that are not already part of the prototype) are stored in
this list column.}
}
}
}
}

\section{Fields}{


\describe{
\item{\code{dt}}{Get the log recorded by this \code{Appender} as a \code{data.table}
with a maximum of \code{buffer_size} rows}
}



\describe{
\item{\code{data}}{Get the log recorded by this \code{Appender} as a \code{data.frame}}
}



\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Methods}{

\describe{
\item{\code{show(n, threshold)}}{Show the last \code{n} log entries with a log level
bellow \code{threshold}. The log entries will be formatted for console output
via this Appenders \link{Layout}}
}


\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\section{Comparison AppenderBuffer and AppenderDt}{


Both \link{AppenderBuffer} and \link{AppenderDt} do in memory buffering of events.
AppenderBuffer retains a copies of the events it processes and has the
ability to pass the buffered events on to other Appenders. AppenderDt
converts the events to rows in a \code{data.table} and is a bit harder to
configure. Used inside loops (several hundred iterations),
AppenderDt has much less overhead than AppenderBuffer. For single logging
calls and small loops, AppenderBuffer is more performant. This is related to
how memory pre-allocation is handled by the appenders.

In short: Use AppenderDt if you want an in-memory log for interactive use,
and AppenderBuffer if you actually want to buffer events
}

\examples{
lg <- get_logger("test")
lg$config(list(
  appenders = list(memory = AppenderBuffer$new()),
  threshold = NA,
  propagate = FALSE  # to prevent routing to root logger for this example
))
lg$debug("test")
lg$error("test")

# Displaying the log
lg$appenders$memory$data
lg$appenders$memory$show()
show_log(target = lg$appenders$memory)

# If you pass a Logger to show_log(), it looks for the first AppenderDt
# that it can find.
show_log(target = lg)

# Custom fields are stored in the list column .custom by default
lg$info("the iris data frame", caps = LETTERS[1:5])
lg$appenders$memory$data
lg$appenders$memory$data$.custom[[3]]$caps
lg$config(NULL)
}
\seealso{
\link{LayoutFormat}, \link{simple_logging}, \link[data.table:data.table]{data.table::data.table}
}
