% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaanHelperFunctions.R
\name{lavaan2lslxLabels}
\alias{lavaan2lslxLabels}
\title{lavaan2lslxLabels}
\usage{
lavaan2lslxLabels(lavaanModel)
}
\arguments{
\item{lavaanModel}{model of class lavaan}
}
\value{
list with lavaan labels and lslx labels
}
\description{
helper function: lslx and lavaan use slightly different parameter labels. This function
can be used to get both sets of labels.
}
\examples{
library(lessSEM)

# Identical to regsem, lessSEM builds on the lavaan
# package for model specification. The first step
# therefore is to implement the model in lavaan.

dataset <- simulateExampleData()

lavaanSyntax <- "
f =~ l1*y1 + l2*y2 + l3*y3 + l4*y4 + l5*y5 + 
     l6*y6 + l7*y7 + l8*y8 + l9*y9 + l10*y10 + 
     l11*y11 + l12*y12 + l13*y13 + l14*y14 + l15*y15
f ~~ 1*f
"

lavaanModel <- lavaan::sem(lavaanSyntax,
                           data = dataset,
                           meanstructure = TRUE,
                           std.lv = TRUE)

lavaan2lslxLabels(lavaanModel)
}
