% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorchecks.R
\name{summary_hfv}
\alias{summary_hfv}
\title{Summary of Class "hfvdata"}
\usage{
summary_hfv(
  object,
  popid = "popid",
  patchid = "patchid",
  individ = "individ",
  year2id = "year2",
  full = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{hfvdata}.}

\item{popid}{A string denoting the name of the variable denoting population
identity.}

\item{patchid}{A string denoting the name of the variable denoting patch
identity.}

\item{individ}{A string denoting the name of the variable denoting individual
identity.}

\item{year2id}{A string denoting the name of the variable denoting the year
in time \emph{t}.}

\item{full}{A logical value indicating whether to include basic data frame
summary information in addition to hfvdata-specific summary information.
Defaults to \code{TRUE}.}

\item{...}{Other parameters.}
}
\value{
A summary of the object. The first line shows the numbers of
populations, patches, individuals, and time steps. If \code{full = TRUE}, 
then this is followed by a standard data frame summary of the hfv dataset.
}
\description{
A function to simplify the viewing of basic information describing
demographic data in historical vertical format (data frames of class
\code{hfvdata}).
}
\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

summary_hfv(cypraw_v1)

}
