% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cypvert}
\alias{cypvert}
\title{Demographic Dataset of \emph{Cypripedium candidum} Population, in Vertical
Format}
\format{
A data frame with 77 individuals, 331 rows, and 12 variables. Each
row corresponds to a specific two-year transition for a specific individual.
Variable codes are similar to those for \code{cypdata}, but use \code{.2} to
identify time \emph{t} and \code{.3} to identify time \emph{t}+1.

\describe{
  \item{plantid}{A numberic variable giving a unique number to each 
  individual.}
  \item{patch}{A variable refering to patch within the population.}
  \item{censor}{A variable coding for whether the data point is valid. An
  entry of 1 means that it is so.}
  \item{year2}{Year in time \emph{t}.}
  \item{Inf2.2}{Number of double inflorescences in time \emph{t}.}
  \item{Inf.2}{Number of inflorescences in time \emph{t}.}
  \item{Veg.2}{Number of stems without inflorescences in time \emph{t}.}
  \item{Pod.2}{Number of fruits in time \emph{t}.}
  \item{Inf2.3}{Number of double inflorescences in time \emph{t}+1.}
  \item{Inf.3}{Number of inflorescences in time \emph{t}+1.}
  \item{Veg.3}{Number of stems without inflorescences in time \emph{t}+1.}
  \item{Pod.3}{Number of fruits in time \emph{t}+1.}
}
}
\source{
Shefferson, R.P., R. Mizuta, and M.J. Hutchings. 2017. Predicting
evolution in response to climate change: the example of sprouting probability
in three dormancy-prone orchid species. \emph{Royal Society Open Science} 
4(1):160647.
}
\usage{
data(cypvert)
}
\description{
A dataset containing the states and fates of \emph{Cypripedium candidum} 
(white lady's slipper orchids), family Orchidaceae, from a population in 
Illinois, USA, resulting from monitoring that occurred annually between 2004 
and 2009. Same dataset as \code{cypdata}, but arranged in an ahistorical
vertical format.
}
\examples{
data(cypvert)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypframe_raw

cypraw_v2 <- historicalize3(data = cypvert, patchidcol = "patch", 
  individcol = "plantid", year2col = "year2", sizea2col = "Inf2.2", 
  sizea3col = "Inf2.3", sizeb2col = "Inf.2", sizeb3col = "Inf.3", 
  sizec2col = "Veg.2", sizec3col = "Veg.3", repstra2col = "Inf2.2", 
  repstra3col = "Inf2.3", repstrb2col = "Inf.2", repstrb3col = "Inf.3", 
  feca2col = "Pod.2", feca3col = "Pod.3", repstrrel = 2, 
  stageassign = cypframe_raw, stagesize = "sizeadded", censorcol = "censor",
  censor = FALSE, NAas0 = TRUE, NRasRep = TRUE, reduce = TRUE)
  
summary(cypraw_v2)

}
\keyword{datasets}
