% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{rlefko3}
\alias{rlefko3}
\title{Create Raw Historical Population Projection Matrices}
\usage{
rlefko3(
  data,
  stageframe,
  year = "all",
  pop = NA,
  patch = NA,
  censor = FALSE,
  stages = NA,
  alive = c("alive3", "alive2", "alive1"),
  size = c("sizea3", "sizea2", "sizea1"),
  repst = c("repstatus3", "repstatus2", "repstatus1"),
  matst = c("matstatus3", "matstatus2", "matstatus1"),
  fec = c("feca3", "feca2", "feca1"),
  repmatrix = NA,
  overwrite = NA,
  yearcol = NA,
  popcol = NA,
  patchcol = NA,
  indivcol = NA,
  censorcol = NA,
  reduce = FALSE
)
}
\arguments{
\item{data}{A vertical demographic data frame, with variables corresponding 
to the naming conventions in \code{\link{verticalize3}()}.}

\item{stageframe}{A stageframe object that includes information on the size,
observation status, propagule status, immaturity status, and maturity status
of each ahistorical stage. Should also incorporate bin widths if size is
continuous.}

\item{year}{A variable corresponding to year or observation time, or a set
of such values, given in values associated with the year term used in linear 
model development. Can also equal \code{all}, in which case matrices will
be estimated for all years. Defaults to \code{all}.}

\item{pop}{A variable designating which populations will have matrices 
estimated. Should be set to specific population names, or to \code{all} if all 
populations should have matrices estimated.}

\item{patch}{A variable designating which patches or subpopulations will
have matrices estimated. Should be set to specific patch names, or to 
\code{all} if all patches should have matrices estimated.}

\item{censor}{If TRUE, then data will be removed according to the variable
set in \code{censorcol}, such that only data with censor values equal to 1
will remain. Defaults to FALSE.}

\item{stages}{An optional but important vector denoting the names of the
variables within the main vertical dataset coding for the names of the stages
of each individual in times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. The names of
the stages in these variables should match those used in the \code{stageframe}
input for this analysis exactly. If left blank, then \code{rlefko3()} will attempt
to infer stages by matching values of \code{alive}, \code{size}, \code{repst}, and \code{matst}
to characteristics noted in the associated \code{stageframe}.}

\item{alive}{A vector of names of binomial variables corresponding to status 
as alive (1) or dead (0) in times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively.}

\item{size}{A vector of names of variables coding size in times \emph{t}+1, \emph{t},
and \emph{t}-1, respectively. Defaults to \code{c("sizea3", "sizea2", "sizea1")}.}

\item{repst}{A vector of names of variables coding reproductive status in 
times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to \code{c("repstatus3", 
"repstatus2", "repstatus1")}.}

\item{matst}{A vector of names of variables coding maturity status in 
times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to \code{c("matstatus3", 
"matstatus2", "matstatus1")}. Must be supplied if \code{stages} is not provided.}

\item{fec}{A vector of names of variables coding fecundity in times \emph{t}+1,
\emph{t}, and \emph{t}-1, respectively. Defaults to \code{c("feca3", "feca2", "feca1")}.}

\item{repmatrix}{A matrix composed mostly of 0s, with non-zero values for
each potentially new individual (row) born to each reproductive stage
(column). Non-zero entries correspond to multipliers for fecundity, with 1
equaling full fecundity.}

\item{overwrite}{A data frame developed with the \code{\link{overwrite}()} function,
describing transitions to be overwritten either with given values or with 
other estimated transitions.}

\item{yearcol}{The variable name or column number corresponding to year 
in time \emph{t} in the dataset.}

\item{popcol}{The variable name or column number corresponding to the
identity of the population.}

\item{patchcol}{The variable name or column number corresponding to patch in 
the dataset.}

\item{indivcol}{The variable name or column number coding individual 
identity.}

\item{censorcol}{The variable name or column number denoting the
censor status. Only needed if \code{censor = TRUE}.}

\item{reduce}{A logical value denoting whether to remove historical stages
associated with only zero transitions. These are removed only if all row
and column sums in ALL matrices estimated equal 0. Defaults to FALSE.}
}
\value{
If all inputs are properly formatted, then this function will return
either an object of class \code{lefkoMat}. Output includes:

\item{A}{A list of full projection matrices in order of sorted populations,
patches, and years.}
\item{U}{A list of survival-transition matrices sorted as in \code{A}.}
\item{F}{A list of fecundity matrices sorted as in \code{A}.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical 
stages used to create historical stage pairs.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages.}
\item{labels}{A data frame giving the population, patch, and year of each 
matrix in order.}
\item{matrixqc}{A short vector describing the number of non-zero elements
in \code{U} and \code{F} matrices, and the number of annual matrices.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input.}
}
\description{
\code{rlefko3()} returns a list of raw historical population projection 
matrices, as well as the associated component transition and fecundity
matrices, data frames describing the ahistorical stages used and the pairing
of ahistorical stages used to create historical paired stages, and a data
frame describing the population, patch, and year associated with each matrix.
}
\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", 
                 "Sm", "Md", "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
                          repstatus = repvector, obsstatus = obsvector,
                          matstatus = matvector, propstatus = propvector,
                          immstatus = immvector, indataset = indataset,
                          binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
                          patchidcol = "patch", individcol = "plantid",
                          blocksize = 4, size1col = "Inf2.04", size2col = "Inf.04",
                          size3col = "Veg.04", repstr1col = "Inf.04",
                          repstr2col = "Inf2.04", fec1col = "Pod.04",
                          stageassign = cypframe_raw, stagesize = "sizeadded",
                          NAas0 = TRUE, NRasRep = TRUE)

rep_cyp_raw <- matrix(0, 11, 11)
rep_cyp_raw[1:2,7:11] <- 0.5

cypover3r <- overwrite(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "D", "XSm", "Sm",
                       "SL", "SL", "SL"), stage2 = c("SD", "SD", "SD", "SD", "P1", "P2",
                       "P3", "P3", "P3", "P3", "SL", "SL"), stage1 = c("SD", "rep", "SD",
                       "rep", "SD", "P1", "P2", "P2", "P2", "P2", "P3", "SL"),
                       eststage3 = c(NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA, NA),
                       eststage2 = c(NA, NA, NA, NA, NA, NA, "D", "D", "D", NA, NA, NA),
                       eststage1 = c(NA, NA, NA, NA, NA, NA, "D", "D", "D", NA, NA, NA),
                       givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, NA, NA, NA, 0.25, 0.4, 0.4),
                       type = c("S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"))

cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw, year = "all",
                       patch = "all", stages = c("stage3", "stage2", "stage1"),
                       size = c("size3added", "size2added", "size1added"),
                       repmatrix = rep_cyp_raw, overwrite = cypover3r,
                       yearcol = "year2", patchcol = "patchid", indivcol = "individ")

summary(cypmatrix3r)

}
