% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_answers.R
\name{correct}
\alias{correct}
\alias{incorrect}
\alias{mark_as}
\title{Mark submission as correct or incorrect}
\usage{
correct(messages = NULL)

incorrect(messages = NULL)

mark_as(correct, messages = NULL)
}
\arguments{
\item{messages}{A vector of messages to be displayed.  The type of message
will be determined by the \code{correct} value. Note that markdown messages are
not rendered into HTML, but you may provide HTML using \code{\link[htmltools:HTML]{htmltools::HTML()}}
or \link[htmltools:builder]{htmltools::tags}.}

\item{correct}{Logical: is the question answer is correct}
}
\value{
Returns a list with class \code{learnr_mark_as} to be returned from the
\code{\link[=question_is_correct]{question_is_correct()}} method for the learnr question type.
}
\description{
Helper method to communicate that the user's submission was correct or
incorrect. These functions were originally designed for developers to create
\code{\link[=question_is_correct]{question_is_correct()}} methods for custom question types, but they can also
be called inside the functions created by \code{\link[=answer_fn]{answer_fn()}} to dynamically
determine the result and message provided to the user.
}
\examples{
# Radio button question implementation of `question_is_correct`
question_is_correct.radio <- function(question, value, ...) {
  for (ans in question$answers) {
    if (as.character(ans$option) == value) {
      return(mark_as(ans$correct, ans$message))
    }
  }
  mark_as(FALSE, NULL)
}

}
\seealso{
\code{\link[=answer_fn]{answer_fn()}}
}
