% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{safe}
\alias{safe}
\title{Execute R code in a safe R environment}
\usage{
safe(expr, ..., show = TRUE, env = safe_env())
}
\arguments{
\item{expr}{expression that contains all the necessary library calls to
execute.  Expressions within callr do not inherit the existing,
loaded libraries.}

\item{...}{parameters passed to \code{callr::\link[callr]{r}}}

\item{show}{Logical that determines if output should be displayed}

\item{env}{Environment to evaluate the document in}
}
\value{
The result of \code{expr}.
}
\description{
When rendering (or running) a document with R markdown, it inherits the
current R Global environment.  This will produce unexpected behaviors,
such as poisoning the R Global environment with existing variables.  By
rendering the document in a new, safe R environment, a \emph{vanilla},
rendered document is produced.
}
\details{
The environment variable \code{LEARNR_INTERACTIVE} will be set to \code{"1"}
or \code{"0"} depending on if the calling session is interactive or not.

Using \code{safe} should only be necessary when locally deployed.
}
\examples{
\dontrun{
# Direct usage
safe(run_tutorial("hello", package = "learnr"))

# Programmatic usage
library(rlang)

expr <- quote(run_tutorial("hello", package = "learnr"))
safe(!!expr)

tutorial <- "hello"
safe(run_tutorial(!!tutorial, package = "learnr"))
}

}
