% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz_print.R
\name{format.tutorial_question_answer}
\alias{format.tutorial_question_answer}
\alias{format.tutorial_question}
\alias{format.tutorial_quiz}
\alias{print.tutorial_question}
\alias{print.tutorial_question_answer}
\alias{print.tutorial_quiz}
\title{Formatting and printing quizzes, questions, and answers}
\usage{
\method{format}{tutorial_question_answer}(x, ..., spacing = "")

\method{format}{tutorial_question}(x, ..., spacing = "")

\method{format}{tutorial_quiz}(x, ...)

\method{print}{tutorial_question}(x, ...)

\method{print}{tutorial_question_answer}(x, ...)

\method{print}{tutorial_quiz}(x, ...)
}
\arguments{
\item{x}{object of interest}

\item{...}{ignored}

\item{spacing}{Text to be placed at the beginning of each new line}
}
\description{
Notes:
\itemize{
\item If custom question types are created, custom s3 formating methods may be implemented as well.
\item Due to the shiny runtime of questions, a text representation of quizzes, questions, and answers will be presented.
}
}
\examples{
ex_question <- question("What number is the letter A in the alphabet?",
  answer("8"),
  answer("14"),
  answer("1", correct = TRUE),
  answer("23"),
  incorrect = "See [here](https://en.wikipedia.org/wiki/English_alphabet) and try again.",
  allow_retry = TRUE
)
cat(format(ex_question), "\\n")
}
\seealso{
\code{\link{quiz}}, \code{\link{question}}, \code{\link{answer}}
}
