% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapkeyIcon.R
\name{addMapkeyMarkers}
\alias{addMapkeyMarkers}
\title{Add Mapkey Markers}
\usage{
addMapkeyMarkers(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  icon = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  data = leaflet::getMapData(map)
)
}
\arguments{
\item{map}{the map to add mapkey Markers to.}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{icon}{the icon(s) for markers;}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools]{htmlEscape}()}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{options}{a list of extra options for markers. See
\code{\link[leaflet]{markerOptions}}}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
the new \code{map} object
}
\description{
Add Mapkey Markers
}
\examples{
library(leaflet)

leaflet()  \%>\%
  addTiles() \%>\%
  addMapkeyMarkers(data = breweries91,
                icon = makeMapkeyIcon(icon = "mapkey",
                                      iconSize = 30,
                                      boxShadow = FALSE,
                                      background = "transparent"),
                group = "mapkey",
                label = ~state, popup = ~village)
}
\references{
\url{https://github.com/mapshakers/leaflet-mapkey-icon}
}
\seealso{
Other Mapkey Functions: 
\code{\link{[.leaflet_mapkey_icon_set}()},
\code{\link{makeMapkeyIcon}()},
\code{\link{mapkeyIconList}()},
\code{\link{mapkeyIcons}()}
}
\concept{Mapkey Functions}
