% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homebutton.R
\name{addHomeButton}
\alias{addHomeButton}
\alias{removeHomeButton}
\title{Add a home button / zoom-to-layer button to a map.}
\usage{
addHomeButton(map, ext, group = "layer", position = "bottomright", add = TRUE)

removeHomeButton(map)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{ext}{the extent / bbox to zoom to.}

\item{group}{the name of the group/layer to be zoomed to (or any character
string)}

\item{position}{the position of the button (one of 'topleft', 'topright',
'bottomleft', 'bottomright'). Defaults to 'bottomright'.}

\item{add}{logical. Whether to add the button to the map (mainly for internal use).}
}
\description{
This function adds a button to the map that enables zooming to a
provided extent / bbox.
}
\section{Functions}{
\itemize{
\item \code{removeHomeButton()}: remove a homeButton from a map

}}
\examples{
library(leaflet)
library(raster)

## pass a group name only
m <- leaflet() \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addCircleMarkers(data = breweries91, group = "breweries91") \%>\%
  addHomeButton(group = "breweries91")
m

## pass a raster extent - group can now be an arbitrary label
m <- leaflet() \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addCircleMarkers(data = breweries91, group = "breweries91") \%>\%
  addHomeButton(ext = extent(breweries91), group = "Brew")
m

## remove the button
removeHomeButton(m)

}
