% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.cluster.h.group}
\alias{s.cluster.h.group}
\title{Group Variables with Hierarchical Clustering}
\usage{
s.cluster.h.group(
  data,
  nGroups = 2,
  threshold = 0,
  distance = "correlation",
  linkage = "single",
  correlation = "pearson"
)
}
\arguments{
\item{data}{A numeric matrix with variables in the columns.}

\item{nGroups}{Integer value specifying the number of required groups.}

\item{threshold}{Numeric value specifying a threshold for omitting variables.
If the distance between two variables in a group is less than this value, the second one will be omitted.
Note that a change in the order of the columns might change the results.}

\item{distance}{Character string specifying how distances are calculated.
It can be \code{correlation}, \code{absCorrelation}, \code{euclidean}, \code{manhattan}, or \code{maximum}.
See \code{\link{s.distance}} function.}

\item{linkage}{Character string specifying how distances are calculated in a left-right node merge.
It can be \code{single}, \code{complete}, \code{uAverage}, \code{wAverage}, or \code{ward}.
See \code{\link{s.cluster.h}} function.}

\item{correlation}{Character string specifying the type of correlation if \code{distance} is correlation.
It can be \code{pearson} or \code{spearman}. See \code{\link{s.distance}} function.}
}
\value{
A list with the following items:
\item{groups}{A list of integer vectors representing the indexes of variables in each group. }
\item{removed}{An integer vector representing the indexes of removed variables.}
}
\description{
This function groups the columns of a numeric matrix based on the hierarchical clustering algorithm.
}
\details{
The results might be different from R's 'cutree' function.
(I don't know how 'cutree' works) Here this function iterates over the nodes and
whenever a split occurs, it adds a group until the required number of groups is reached.
}
