% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/search_exhaustive.R
\name{search_exhaustive}
\alias{search_exhaustive}
\title{Searches the space backwards, prefering more subjects and better ratios.
While the search is done in parallel, the search space is enormous and so
it can be very slow in the worst case. It is perhaps most useful as a tool
to study other matching procedures.}
\usage{
search_exhaustive(sspace, condition, covariates, halting_test, thresh, props,
  print_info)
}
\arguments{
\item{sspace}{An ordered subject subspace: a list of vectors,
with one vector per group containing the corresponding subject indices.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A vector or columnwise matrix containing
                     covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
                     which is TRUE iff the conditions are matched.}

\item{thresh}{The statistical threshold to pass onto the
                     aforementioned test.}

\item{props}{The desired proportions (percentage) of the sample for
                     each condition; if not specified, the (full)
                     sample proportions are used. This is used
                     for the "heuristic" and "exhaustive" methods.}

\item{print_info}{If TRUE, prints summary information on the input and the
                     results, as well as progress information for the
                     exhaustive search algorithm. Default: TRUE;
                     can be changed using set_param("PRINT_INFO", FALSE).}
}
\value{
A list of logical vector(s) for best set(s) of subjects to be kept.
}
\description{
Searches the space backwards, prefering more subjects and better ratios.
While the search is done in parallel, the search space is enormous and so
it can be very slow in the worst case. It is perhaps most useful as a tool
to study other matching procedures.
}

