% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/search_exhaustive.R
\name{check_subspaces_for_group_size_setup}
\alias{check_subspaces_for_group_size_setup}
\title{Searches over all possible subspaces for specified group size setup.}
\usage{
check_subspaces_for_group_size_setup(best, grpsize_setup, sspace, condition,
  covariates, halting_test, thresh, print_info)
}
\arguments{
\item{best}{The best matched groups so far together with its
                  p-value / thresh ratio; a list containing ratio and inds
                  (a list of subject index vectors).}

\item{grpsize_setup}{A set of group sizes as a data.table row (also a list).}

\item{sspace}{An ordered subject subspace: a list of vectors,
with one vector per group containing the corresponding subject indices.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A vector or columnwise matrix containing
                     covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
                     which is TRUE iff the conditions are matched.}

\item{thresh}{The statistical threshold to pass onto the
                     aforementioned test.}

\item{print_info}{If TRUE, prints summary information on the input and the
                     results, as well as progress information for the
                     exhaustive search algorithm. Default: TRUE;
                     can be changed using set_param("PRINT_INFO", FALSE).}
}
\value{
The best
}
\description{
Searches over all possible subspaces for specified group size setup.
}

