% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetdocu.R
\docType{data}
\name{danube}
\alias{danube}
\title{Ranks of preprocessed monthly Danube river flow measurements}
\format{
This data frame contains the following columns:
\itemize{
     \item{inn}{A numeric vector containing the rank of prewhitened level observations of the Inn river at Nagyramos.}
     \item{donau}{A numeric vector containing the rank of prewhitened level observations of the Donau river at Scharding.}
}
}
\source{
Vorosmarty, C.J., Fekete, B.M., Tucker, B.A. (1998).   Global River Discharge, 1807--1991, V. 1.1(RivDIS). Data set.   Available from \code{http://doi.org/10.3334/ORNLDAAC/199}
}
\description{
The \code{danube} dataset contains ranks of base flow observations from the Global River Discharge project of the Oak Ridge National Laboratory Distributed Active Archive Center (ORNL DAAC), a NASA data center. The measurements are monthly average flow rate for two stations situated at Scharding (Austria) on the Inn river and at Nagymaros (Hungary) on the Danube.
 The data have been pre-processed to remove any time trend. Specifically, Bacigal et al. (2011) extracted the raw data, and obtain the fast Fourier transformed centered observations. The negative spectrum is retained and a linear time series model with 12 seasonal components is fitted. Residuals are then extracted and AR model fitted to the series, the selection being done based on the AIC criterion with imposed maximum order of 3 and the number of autoregressive components may differ for each series.
}
\references{
Bacigal, T., Jagr, V., Mesiar, R. (2011)  Non-exchangeable random variables, Archimax copulas and their fitting to real data.   \emph{Kybernetika}, \bold{47}(4), 519--531.  

Genest, C. and Neslehova, J. G. (2013)  Assessing and Modeling Asymmetry in Bivariate Continuous Data.  In P. Jaworski, F. Durante, and W. K. Hardle (Eds.),  Copulae in Mathematical and Quantitative Finance, Lecture Notes in Statistics, 91--114, Springer: Berlin Heidelberg.
}
\keyword{datasets}
