% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{rarchi}
\alias{rarchi}
\title{Archimedean copula sampler}
\usage{
rarchi(n, family, d, theta)
}
\arguments{
\item{n}{sample size}

\item{family}{family of the Archimedean copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{d}{dimension of sample}

\item{theta}{parameter of the Archimedean copula}
}
\value{
a sample of dimension \code{n} by \code{d} from the Archimedean copula
}
\description{
Sampler based on the Marshall-Olkin algorithm
}
\examples{
#Sample from a Gumbel Archimedean copula
rarchi(n = 100, "gumbel", d = 4, theta = 2)
#Sample from the independence copula
rarchi(n = 100, "gumbel", d = 4, theta = 1)
}

