% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictYcond.R
\name{predictYcond}
\alias{predictYcond}
\title{Conditional predictions of a \code{lcmm}, \code{multlcmm} or \code{Jointlcmm}
object in the natural scale of the longitudinal outcome(s) for specified
latent process values.}
\usage{
predictYcond(
  x,
  lprocess,
  condRE_Y = FALSE,
  nsim = 200,
  draws = FALSE,
  ndraws = 2000,
  ...
)
}
\arguments{
\item{x}{an object inheriting from class \code{lcmm}, 
\code{Jointlcmm} or \code{multlcmm} representing a general latent class
mixed model.}

\item{lprocess}{numeric vector containing the latent process values at which the
predictions should be computed.}

\item{condRE_Y}{for multlcmm objects only, logical indicating if the predictions
are conditional to the outcome specific random effects or not. Default to FALSE,
the predictions are marginal to these random effects.}

\item{nsim}{number of points used in the numerical integration (Monte-Carlo) with
splines or Beta link functions. nsim should be relatively important
(nsim=200 by default).}

\item{draws}{optional boolean specifying whether median and confidence bands
of the predicted values should be computed (TRUE) - whatever the type of
link function. A Monte Carlo approximation of the posterior distribution of the
predicted values is computed and the median, 2.5\% and 97.5\% percentiles
are given. Otherwise, the predicted values are computed at the point
estimate. By default, draws=FALSE.}

\item{ndraws}{if draws=TRUE, ndraws specifies the number of draws that should be
generated to approximate the posterior distribution of the predicted values.
By default, ndraws=2000.}

\item{\dots}{further arguments to be passed to or from other methods.  They
are ignored in this function.}
}
\value{
An object of class \code{predictYcond} with values :

- \code{pred} : 
If draws=FALSE, returns a matrix with 3 columns : the first column indicates the
name of the outcome, the second indicates the latent process value and the last
is the computed prediction.
If draws=TRUE, returns a matrix with 5 columns : the name of the outcome, the
latent process value and the 50\%, 2.5\% and 97.5\% percentiles of the approximated
posterior distribution of predicted values.

- \code{object} : the model from which the predictions are computed.
}
\description{
The function computes the predicted values of the longitudinal markers in their
natural scale for specified values of the latent process. For splines and Beta
links, a Gauss-Hermite integration is used to numerically compute the predictions.
In addition, for any type of link function, confidence bands (and median) can be
computed by a Monte Carlo approximation of the posterior distribution of the
predicted values.
}
\examples{
\dontrun{
m12 <- lcmm(Ydep2~Time+I(Time^2),random=~Time,subject='ID',ng=1,
data=data_lcmm,link="3-equi-splines")
predm12 <- predictYcond(m12,lprocess=seq(-8,2,length.out=100),draws=TRUE)
plot(predm12)
}

}
\seealso{
\code{\link{predictY}}, \code{\link{predictlink}}
}
\author{
Cecile Proust-Lima, Viviane Philipps
}
