% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.lcc}
\alias{plot.lcc}
\title{Diagnostic Plots of an \code{lcc} Object.}
\usage{
\method{plot}{lcc}(x, which = c(1L:6L),
     caption = list("Residuals vs Fitted",
                    "Residuals vs Time",
                    "Residuals by Subject",
                    "Observed values vs Fitted values",
                    "Normal Q-Q Plot (Conditional residuals)",
                    "Normal Q-Q Plot (Random effects)"),
     sub.caption =  NULL,  main = NULL,
     panel = if(add.smooth) panel.smooth else points,
     add.smooth = TRUE, ask = TRUE,
     id.n = 3, labels.id = names(residuals(x)),
     label.pos = c(4, 2), cex.id = 0.75, cex.caption = 1,
     cex.oma.man = 1.25, ...)
}
\arguments{
\item{x}{an object inheriting from class \code{\link[lcc]{lcc}},
representing a fitted longitudinal concordance correlation
function.}

\item{which}{if a subset of the plots is required, specify a subset
of the numbers from 1 to 6.}

\item{caption}{captions to appear above the plots. Vector or list of
valid graphics annotations is required. All captions can be
supressed using '""' or \code{NA}.}

\item{sub.caption}{common sub-title (at bottom). Default to
\code{NULL}.}

\item{main}{The main title (on top) above the caption.}

\item{panel}{panel function. If \code{add.smooth = TRUE},
\code{panel.smooth} is used rather than \code{points}.}

\item{add.smooth}{logical indicating if smoother should be added to
most plots; see also \code{panel} above. Defaults to \code{TRUE}.}

\item{ask}{logical; if \code{TRUE}, the default, the user is _ask_ed
before each plot, see \code{\link[graphics]{par}}.}

\item{id.n}{number of points to be labelled is the first three
plots, starting with the most extreme.}

\item{labels.id}{vector of labels, from which the labels for extreme
points will be chosen. Default to \code{NULL} (uses observation
numbers).}

\item{label.pos}{positioning of labels, for the left half and right
half of the graph respectively, for plots 1-3.}

\item{cex.id}{magnification of point label.}

\item{cex.caption}{controls the size of \code{caption}.}

\item{cex.oma.man}{controls the size of the \code{sub.caption} only
if that is _above_ the figures when there is more than one.}

\item{...}{further graphical parameters from 'par'.}
}
\description{
Diagnostic plots for conditional error and random
effects from the linear mixed-effects fit are obtained. Six plots
plots (selectable by 'which') are currently available: a plot of
residuals against fitted values, a plot of residuals against
time variable, a boxplot of residuals by subject,
a plot of observerd values against fitted values, a normal Q-Q plot
with simulation envelopes based on conditional error,  and a normal
Q-Q plot with simulation envelopes based on the random effects. By
default, all plots are provided.
}
\details{
The Q-Q plot uses the normalized residuals. The
  standardized residuals is pre-multiplied by the inverse
  square-root factor of the estimated error correlation matrix while
  the random effects is pre-multiplied by the inverse square root of
  the estimated variances obtained from matrix G. The simulate
  envelopes are obtained from package hnp (Moral et al.,  2018).

  Code partially adapted from \code{\link[stats]{plot.lm}}.
}
\examples{

## Second degree polynomial model with random intercept, slope and
## quadratic term
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2)
plot(fm1)
}
\seealso{
\code{\link{lccPlot}}, \code{\link[lcc]{lcc}},
  \code{mtext}, \code{text}, \code{plotmath}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@usp.br}
}
