% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.anova.lcc}
\alias{print.anova.lcc}
\title{Print the Anova of an \code{lcc} Object}
\usage{
\method{print}{anova.lcc}(x, verbose, ...)
}
\arguments{
\item{x}{an object inheriting from class
\code{\link[lcc]{anova.lcc}}, representing a fitted longitudinal
concordance correlation function.}

\item{verbose}{an optional logical value used to control the amount
of printed output. If \code{TRUE}, the calling sequences for each fitted
model object are printed with the rest of the output, being omitted
if \code{verbose = FALSE}. Defaults to \code{FALSE}.}

\item{...}{further arguments passed to \code{\link{print}}.}
}
\description{
Method print for the \code{anova.lcc}.
}
\details{
Modified from \code{\link{anova.lme}}. For more details see
methods for \code{\link{nlme}}.
}
\examples{

\dontrun{
## Second degree polynomial model with random intercept, slope and
## quadratic term
fm1<-lcc(dataset = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
print(anova(fm1))
}

}
\seealso{
\code{\link{summary.lcc}}, \code{\link{lccPlot}},
  \code{\link[lcc]{lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@usp.br}
}
