\name{Latent Budget Analysis}
\alias{lba-package}

\docType{package}

\title{Latent Budget Analysis (LBA) for Compositional Data}

\description{Latent budget analysis (LBA) is a method for the analysis of contingency tables, from where the compositional data is derived. It is used to understand the relationship between the table rows and columns, where the rows denote the categories of the explanatory variable and the columns denote the categories of the response variable.
}

\details{The row vectors of the compositional data are called observed budgets which are approximated by the expected budgets. The LBA allows us to find which categories of the response are related to different groups of the explanatory categories. If the table has a product multinomial distribution we can understand the latent budget model (LBM) as explaining the relationship between the explanatory and the response variables assuming that conditioned on the latent variable they are independent. In that sense, the latent budgets, which are categories of a latent variable, are hidden values which explain the relationship between the explanatory and response variables. LBA reduce the dimensionality of the original problem, thus making it easier to understand its hidden relations.
}

\author{
Enio G. Jelihovschi <eniojelihovs@gmail.com> and Ivan Bezerra Allaman <ivanalaman@gmail.com>. We are grateful to Jose C. Faria, Andreas L. van der Ark and Fabio M. Correa for suggestions.

Maintainer: Enio G. Jelihovschi <eniojelihovs@gmail.com>
}

\keyword{package}
