% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/make-call.R
\name{make_call}
\alias{make_call}
\title{Make a call with \code{lazy_dots} as arguments.}
\usage{
make_call(fun, args)
}
\arguments{
\item{fun}{Function as symbol or quoted call.}

\item{args}{Arguments to function; must be a \code{lazy_dots} object,
or something \code{\link{as.lazy_dots}()} can coerce..}
}
\value{
A list:
  \item{env}{The common environment for all elements}
  \item{expr}{The expression}
}
\description{
In order to exactly replay the original call, the environment must be the
same for all of the dots. This function circumvents that a little,
falling back to the \code{\link{baseenv}()} if all environments aren't
the same.
}
\examples{
make_call(quote(f), lazy_dots(x = 1, 2))
make_call(quote(f), list(x = 1, y = ~x))
make_call(quote(f), ~x)

# If no known or no common environment, fails back to baseenv()
make_call(quote(f), quote(x))
}

