% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_fit.R
\name{nice_fit}
\alias{nice_fit}
\title{Extract relevant fit indices from lavaan model}
\usage{
nice_fit(..., nice_table = FALSE)
}
\arguments{
\item{...}{lavaan model objects to extract fit indices from}

\item{nice_table}{Logical, whether to print the table as a
\code{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}
}
\value{
A dataframe, representing select fit indices (chi2, df, chi2/df,
p-value of the chi2 test, CFI, TLI, RMSEA, SRMR, AIC, and BIC).
}
\description{
Compares fit from one or several lavaan models. Also
optionally includes references values. The reference fit values are
based on Schreiber et al. (2006).
}
\examples{
(latent <- list(visual = paste0("x", 1:3),
                textual = paste0("x", 4:6),
                speed = paste0("x", 7:9)))

(regression <- list(ageyr = c("visual", "textual", "speed"),
                    grade = c("visual", "textual", "speed")))

HS.model <- write_lavaan(latent = latent, regression = regression)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data=HolzingerSwineford1939)
nice_fit(fit)
}
\references{
Schreiber, J. B., Nora, A., Stage, F. K., Barlow, E. A., & King,
J. (2006). Reporting structural equation modeling and confirmatory factor
analysis results: A review. \emph{The Journal of educational research}, \emph{99}(6),
323-338. https://doi.org/10.3200/JOER.99.6.323-338
}
\keyword{CFA}
\keyword{analysis}
\keyword{equation}
\keyword{lavaan}
\keyword{modeling}
\keyword{path}
\keyword{structural}
