% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-moments2.R
\name{moments2}
\alias{moments2}
\alias{moments2.lvm}
\alias{moments2.lvmfit}
\title{Compute Key Quantities of a Latent Variable Model}
\usage{
moments2(
  object,
  param,
  data,
  weights,
  Omega,
  Psi,
  initialize,
  usefit,
  update.dmoment,
  update.d2moment,
  score,
  information,
  hessian,
  vcov,
  dVcov,
  dVcov.robust,
  residuals,
  leverage,
  derivative
)

\method{moments2}{lvm}(
  object,
  param = NULL,
  data = NULL,
  weights = NULL,
  Omega = NULL,
  Psi = NULL,
  initialize = TRUE,
  usefit = TRUE,
  update.dmoment = TRUE,
  update.d2moment = TRUE,
  score = TRUE,
  information = TRUE,
  hessian = TRUE,
  vcov = TRUE,
  dVcov = TRUE,
  dVcov.robust = TRUE,
  residuals = TRUE,
  leverage = TRUE,
  derivative = "analytic"
)

\method{moments2}{lvmfit}(
  object,
  param = NULL,
  data = NULL,
  weights = NULL,
  Omega = NULL,
  Psi = NULL,
  initialize = TRUE,
  usefit = TRUE,
  update.dmoment = TRUE,
  update.d2moment = TRUE,
  score = TRUE,
  information = TRUE,
  hessian = TRUE,
  vcov = TRUE,
  dVcov = TRUE,
  dVcov.robust = TRUE,
  residuals = TRUE,
  leverage = TRUE,
  derivative = "analytic"
)
}
\arguments{
\item{object}{a latent variable model.}

\item{param}{[numeric vector] value of the model parameters if different from the estimated ones.}

\item{data}{[data.frame] dataset if different from the one used to fit the model.}

\item{Psi}{[matrix]  Average first order bias in the residual variance. Only necessary for computing adjusted residuals.}

\item{initialize}{[logical] Pre-compute quantities dependent on the data but not on the parameters values.}

\item{usefit}{[logical] Compute key quantities based on the parameter values.}

\item{update.dmoment}{[logical] should the first derivative of the moments be computed/updated?}

\item{update.d2moment}{[logical] should the second derivative of the the moments be computed/updated?}

\item{score}{[logical] should the score be output?}

\item{information}{[logical] should the expected information be output?}

\item{hessian}{[logical] should the hessian be output?}

\item{vcov}{[logical] should the variance-covariance matrix based on the expected information be output?}

\item{dVcov}{[logical] should the derivative of the variance-covariance matrix be output?}

\item{dVcov.robust}{[logical]  should the derivative of the robust variance-covariance matrix be output?}

\item{...}{[internal] only used by the generic method or by the <- methods.}
}
\description{
Compute conditional mean, conditional variance, their first and second derivative regarding model parameters, as well as various derivatives of the log-likelihood.
}
\details{
For lvmfit objects, there are two levels of pre-computation:
\itemize{
\item a basic one that do no involve the model coefficient (\code{conditionalMoment.lvm}).
\item an advanced one that require the model coefficients (\code{conditionalMoment.lvmfit}). 
}
}
\examples{
m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta

d <- lava::sim(m,1e2)
e <- estimate(m, d)

## basic pre-computation
res1 <- moments2(e, data = d, initialize = TRUE, usefit = FALSE,
                score = TRUE, information = TRUE, hessian = TRUE, vcov = TRUE,
                dVcov = TRUE, dVcov.robust = TRUE, residuals = TRUE, leverage = FALSE,
                derivative = "analytic")
res1$skeleton$param$Sigma

## full pre-computation
res2 <- moments2(e, param = coef(e), data = d, initialize = TRUE, usefit = TRUE,
                score = TRUE, information = TRUE, hessian = TRUE, vcov = TRUE,
                dVcov = TRUE, dVcov.robust = TRUE, residuals = TRUE, leverage = FALSE,
                derivative = "analytic")
res2$moment$Omega

}
\concept{derivative of the score equation}
\concept{small sample inference}
\keyword{internal}
